let selectedNoticeUid;
let readNoticeList = JSON.parse(localStorage.getItem('readNoticeList')) || [];
let cachedNotices; // 캐시된 공지사항 데이터

$(document).ready(function() {
    // 페이지가 로드될 때 읽은 공지사항 표시
    markReadNotices(readNoticeList);

    // 알람 셀렉트 박스 변경 이벤트 핸들러
    $("#alarmSelect").change(function() {
        let selectedTabId = $(".tabnav li a.active").attr('href');
        updateNotices(selectedTabId);
    });

    // 탭 변경 이벤트 핸들러
    $('a[data-toggle="tab"]').on('shown.bs.tab', function (e) {
        let selectedTabId = $(e.target).attr('href');
        updateNotices(selectedTabId);
    });

    // 공지사항 발송 버튼 클릭 이벤트 핸들러
    $(document).on("click", ".btn_confirm_pop", function(){
        selectedNoticeUid = $(this).closest("li").find(".btn_notice_view").attr("id");
        $(".btn_submit.sendNotice").data("notice-id", selectedNoticeUid); // 발송 버튼에 선택된 공지사항 ID 저장
        $(".confirm_pop").show(); // 확인 팝업 열기
    });

    // 공지사항 삭제 버튼 클릭 이벤트 핸들러
    $(document).on("click", ".btn_delete_notice", function(){
        selectedNoticeUid = $(this).closest("li").find(".btn_notice_view").attr("id");
        deleteNotice(selectedNoticeUid); // 선택된 공지사항 삭제 함수 호출
    });

    // 모두읽음 버튼 클릭 이벤트 핸들러
    $("#readAll").on("click", function(e){
        e.preventDefault();
        e.stopPropagation();
        readAllNotices();
    });

    // 공지사항 필터링 및 표시 함수 호출
    updateNotices("#tab01");
});

// 공지사항 불러오기 및 표시 함수
function updateNotices(tabId) {
    let categoryFilter = getCategoryFilter(tabId);
    let alarmFilter = $("#alarmSelect").val();

    // 캐시된 공지사항 데이터가 없거나, 필터가 변경되었을 때만 서버에서 데이터를 가져옴
    if (!cachedNotices || cachedNotices.categoryFilter !== categoryFilter || cachedNotices.alarmFilter !== alarmFilter) {
        getNoticesFromServer(tabId, categoryFilter, alarmFilter);
    } else {
        addFilteredNoticesToHTML(cachedNotices.notices, categoryFilter);
    }
}

// 선택된 탭의 카테고리 필터를 가져오는 함수
function getCategoryFilter(tabId) {
    if (tabId === "#tab02") {
        return "E"; // "E" 카테고리 필터
    } else if (tabId === "#tab03") {
        return "N"; // "N" 카테고리 필터
    } else {
        return ""; // 다른 탭은 필터 없음
    }
}

// 서버에서 공지사항 데이터를 가져오는 함수
function getNoticesFromServer(tabId, categoryFilter, alarmFilter) {
    // 서버에서 데이터 가져오는 로직 구현
    let tempUrl = server_host + server_port + '/astroapi/notice/v1/notices/all';
    // let tempUrl = server_host + server_port + '/astroapi/notice/v1/notices/user';

    cordova.plugin.http.get(tempUrl, {}, {
        Authorization: 'Bearer ' + userData.astroToken
    }, function (response) {
        let jsonData = JSON.parse(response.data);
        console.log("jsonData.data : " + JSON.stringify(jsonData.data));

        // jsonData.data.uid 내림차순으로 정렬
        jsonData.data.sort(function(a, b) {
            return b.uid - a.uid;
        });

        // 데이터를 가져온 후 캐시 업데이트 및 HTML에 추가
        let notices = jsonData.data; // 서버에서 가져온 공지사항 데이터
        cachedNotices = { notices: notices, categoryFilter: categoryFilter, alarmFilter: alarmFilter };
        addFilteredNoticesToHTML(notices, categoryFilter);
    }, function (response) {
        // 서버에서 데이터를 가져오지 못한 경우 오류 처리
        console.log("공지사항 불러오기 실패 response status:" + JSON.stringify(response));
        console.log(response.error);
        popAlert("오류가 발생했습니다.<br/>잠시 후 다시 시도해 주세요");
    });
}

// 필터링된 공지사항 데이터를 HTML에 추가하는 함수
function addFilteredNoticesToHTML(notices, categoryFilter) {
    let noticeList = $(".notice_list");
    noticeList.empty(); // 기존의 공지사항을 모두 지우고 시작

    // 입력된 공지 데이터의 uid 순서대로 리스트를 구성합니다.
    notices.forEach(function (notice) {
        // 카테고리 필터 적용
        if (!categoryFilter || notice.category == categoryFilter) {
            // 알람 시간을 원하는 형식으로 변환
            let formattedDate = notice.alarm_time == null ? "기간 제한없음" : formatDate(new Date(notice.alarm_time));

            // 이미 읽은 공지사항인 경우, 새로운 표시를 없앱니다.
            let isNewClass = readNoticeList.includes(notice.uid) ? '' : `<span class="new">${notice.category}</span>`;

            let noticeItem = `
                <li class="pull_delete">
                    <div>
                        <h4 class="btn_notice_view" id="${notice.uid}">${isNewClass} [공지] ${notice.title}</h4>
                        <p>
                            ${formattedDate} / ${notice.creator} <!-- 변환된 날짜 표시 -->
                            <span class="func">
                                ${notice.creator === window.localStorage.getItem("verifyUser") ? `
                                    <button class="btn btn_confirm_pop" type="button" name="" id="${notice.uid}"><i class="ri-send-plane-2-line"></i></button>
                                    <button class="btn btn_edit_notice" type="button" name="" id="${notice.uid}"><i class="ri-edit-2-line"></i></button>
                                    <button class="btn btn_delete_notice" type="button" name="" id="${notice.uid}"><i class="ri-delete-bin-line"></i></button>
                                ` : ''}
                            </span>
                        </p>
                    </div>
                </li>
            `;
            noticeList.append(noticeItem); // 생성한 공지사항 HTML을 리스트에 추가
        }
    });
}

// 읽은 공지사항 처리하는 함수
function markReadNotices(notices) {
    $(".btn_notice_view").each(function() {
        let noticeUid = $(this).attr("id");
        if (notices.includes(noticeUid)) {
            $(this).find('.new').remove();
        }
    });
}

// 모든 공지를 읽은 것으로 표시하는 함수
function readAllNotices() {
    // 모든 공지 읽은 것으로 처리
    $(".new").removeClass("new");
    readNoticeList = [];

    cachedNotices.notices.forEach(item => {
        readNoticeList.push(item.uid);
    });

    localStorage.setItem('readNoticeList', JSON.stringify(readNoticeList));

    // HTML 갱신
    addFilteredNoticesToHTML(cachedNotices.notices, getCategoryFilter($(".tabnav li a.active").attr('href')));
    $(".new").remove(); // 새로고침 후 모든 새로운 표시 제거
}


// 선택한 공지사항 불러오기 함수
function getSelectedNotice(selectedNoticeUid){
    let tempUrl = server_host + server_port + '/astroapi/notice/v1/notice/' + selectedNoticeUid;

    cordova.plugin.http.get(tempUrl, {}, {
        Authorization: 'Bearer ' + userData.astroToken
    }, function (response) {
        let jsonData = JSON.parse(response.data);
        console.log("jsonData.data : " + JSON.stringify(jsonData.data));
        
        // JSON 데이터를 활용하여 HTML 수정
        let noticeHtml = `
            <div class="head" style="-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none">
                <h4>[공지] ${jsonData.data.title}</h4>
                <p>작성자 : ${jsonData.data.corp_code} / ${jsonData.data.creator}</p>
                <p>작성일 : ${jsonData.data.create_time}</p>
            </div>
            <div class="cont" style="-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none">
                ${jsonData.data.contents}
            </div>
            <div class="btn_box" style="-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none">
                <a href="#" class="notice_forward">전달</a>
                <a href="#" class="notice_view_close">닫기</a>
            </div>
        `;
        
        // HTML을 공지사항 컨테이너에 추가
        $("#notice_container").html(noticeHtml);

        // 현재 탭의 ID 저장
        let currentTabId = $(".tab-content .tab-pane.active").attr("id");
        localStorage.setItem('lastVisitedTabId', currentTabId);

        readNoticeList.push(jsonData.data.uid);
        
    }, function (response) {
        console.log("공지사항 불러오기 실패 response status:" + JSON.stringify(response));
        console.log(response.error);
        popAlert("오류가 발생했습니다.<br/>잠시 후 다시 시도해 주세요");
    });
}