//공지사항
let noticeUids = [];
let currentCategory = "all";
let categoryFilter = "";

let readNoticeList = (JSON.parse(localStorage.getItem('readNoticeList')) || []),
selfDeletedNoticeList = (JSON.parse(localStorage.getItem('selfDeletedNoticeList')) || []);

function getNoticesUids(){
    var tempUrl = server_host + server_port + '/astroapi/notice/v1/notices/all';

    cordova.plugin.http.get(tempUrl, {}, {
        Authorization: 'Bearer ' + window.localStorage.getArray("userData").astroToken
    }, function (response) {
        var jsonData = JSON.parse(response.data);

        noticeUids = jsonData.data.map(function(notice) {
            return notice.uid;
        });

        updateNewNoticeIndicator();

    }, function (response) {
        // prints 403
        popAlert("오류가 발생했습니다.<br/>잠시 후 다시 시도해 주세요");
    });
}

// 읽지 않은 공지사항 알림을 업데이트하는 함수
function updateNewNoticeIndicator() {
    let unreadNoticeCount = noticeUids.filter(uid => !readNoticeList.includes(uid)).length;
    if (unreadNoticeCount > 0) {
        $(".new").show();
    } else {
        $(".new").hide();
    }
}

// 공지사항 불러오기 함수
function getNotices(categoryFilter, callback) {
    let alarmValue = $("#alarmSelect").val();
    let alarmFilter = alarmValue === "Y" ? "Y" : alarmValue === "N" ? "N" : "";

    let tempUrl = server_host + server_port + '/astroapi/notice/v1/notices/all';

    categoryFilter != "" ? categoryFilter : categoryFilter = "all";

    cordova.plugin.http.get(tempUrl, {}, {
        Authorization: 'Bearer ' + userData.astroToken
    }, function(response) {
        let jsonData = JSON.parse(response.data);
        allNotices = jsonData;

        // 공지사항을 내림차순으로 정렬
        jsonData.data.sort((a, b) => b.uid - a.uid);

        // 필터링된 공지사항 가져오기
        let filteredNotices = filterNoticesByAlarm(jsonData.data, alarmFilter);

        // 필터링된 공지사항을 HTML에 추가하는 함수 호출
        addFilteredNoticesToHTML(filteredNotices, categoryFilter);

        // 검색어가 입력되어 있다면 검색 이벤트 트리거
        if ($('#notice_srch_keyword').val() !== '') {
            $('#notice_srch_keyword').trigger('keyup');
        }

        // 공지사항 팝업 표시
        $(".notice_pop").stop().show();

        // 읽은 공지사항 처리
        markReadNotices(filteredNotices);

        let jsonDataUids = jsonData.data.map(notice => notice.uid);

        readNoticeList = readNoticeList.filter(uid => jsonDataUids.includes(uid));

        localStorage.setItem('readNoticeList', JSON.stringify(readNoticeList));

        // 비동기 호출이 완료된 후 콜백 실행
        if (typeof callback === "function") {
            callback();
        }

    }, function(response) {
        console.error("공지사항 불러오기 실패:", response);
        popAlert("공지사항 불러오기 실패 오류가 발생했습니다.<br/>잠시 후 다시 시도해 주세요");
    });
}

// 모든 공지를 읽은 것으로 표시하는 함수   
function readAllNotices() {
    // 모든 공지 읽은 것으로 처리
    $(".new").removeClass("new");
    readNoticeList = [];

    allNotices.data.forEach(item => {
        readNoticeList.push(item.uid);
    });

    localStorage.setItem('readNoticeList', JSON.stringify(readNoticeList));

    // 리스트 갱신
    getNotices(categoryFilter);
    $(".new").remove(); // 새로고침 후 모든 새로운 표시 제거
}

// deleteAll 버튼 클릭 시 실행되는 함수
function deleteAllNotices() {
    // 모든 공지를 읽은 것으로 처리
    $(".new").removeClass("new");

    // selfDeletedNoticeList에 모든 공지를 추가하여 해당 공지를 삭제했음을 표시
    allNotices.data.forEach(item => {
        let uid = item.uid;
        if (!selfDeletedNoticeList.includes(uid)) {
            selfDeletedNoticeList.push(uid);
        }
        // 이미 읽은 공지는 readNoticeList에 유지하도록 수정
        if (!readNoticeList.includes(uid)) {
            readNoticeList.push(uid); // 읽은 것으로 처리
        }
    });

    localStorage.setItem('readNoticeList', JSON.stringify(readNoticeList));
    localStorage.setItem('selfDeletedNoticeList', JSON.stringify(selfDeletedNoticeList));

    // 리스트 갱신
    getNotices(categoryFilter);
}

// 알람 여부에 따라 공지사항 필터링하는 함수
function filterNoticesByAlarm(notices, alarmFilter) {
    if (alarmFilter === "Y") {
        return notices.filter(function(notice) {
            return notice.alarm_result !== null && notice.alarm_result !== '' && notice.alarm_result !== undefined;
        });
    } else if (alarmFilter === "N") {
        return notices.filter(function(notice) {
            return notice.alarm_result === null || notice.alarm_result === undefined || notice.alarm_result === '';
        });
    } else {
        return notices;
    }
}

// 필터링된 공지사항 데이터를 HTML에 추가하는 함수
function addFilteredNoticesToHTML(notices, categoryFilter) {
    let noticeList = $("#noticeList");
    noticeList.empty(); // 기존의 공지사항 목록을 초기화

    // 필터링된 공지사항 데이터를 반복하여 리스트에 추가
    notices.forEach(function(notice) {
        // 삭제된 공지사항 건너뛰기
        if (selfDeletedNoticeList.includes(notice.uid)) return;

        // 카테고리 필터링
        if (!categoryFilter || categoryFilter === "all" || notice.category == categoryFilter) {
            let formattedDate = notice.create_time == null ? "-" : formatDate(new Date(notice.create_time));
            let isNewClass = readNoticeList.includes(notice.uid) ? '' : '<span class="new">N</span>';
            let creatorName = notice.creator_name !== undefined ? notice.creator_name : "알 수 없음";

            let noticeItem = `
                <li class="pull_delete" data-uid="${notice.uid}">
                    <div>
                        <h4 class="btn_notice_view" id="${notice.uid}">${isNewClass} [공지] ${notice.title}</h4>
                        <p>${formattedDate} / ${creatorName}
                        <span class="func">
                            ${((notice.creator === window.localStorage.getItem("verifyUser")) && (window.localStorage.getItem("noticeRegPermitted") === "true")) ? `
                                <button class="btn btn_confirm_pop" type="button" name="" id="${notice.uid}"><i class="ri-send-plane-2-line"></i></button>
                                <button class="btn btn_edit_notice" type="button" name="" id="${notice.uid}"><i class="ri-edit-2-line"></i></button>
                                <button class="btn btn_delete_notice" type="button" name="" id="${notice.uid}"><i class="ri-delete-bin-line"></i></button>
                            ` : ''}
                        </span>
                        </p>
                    </div>
                </li>`;
            noticeList.append(noticeItem);
        }
    });

    // pulldelete 이벤트 핸들러 추가
    $('.pull_delete').pulldelete(function($dom) {
        let uid = $dom.data('uid');

        selfDeletedNoticeList.push(uid);
        readNoticeList.push(uid);
        localStorage.setItem('selfDeletedNoticeList', JSON.stringify(selfDeletedNoticeList));
        localStorage.setItem('readNoticeList', JSON.stringify(readNoticeList));
        $dom.remove();
        updateNewNoticeIndicator();
    });
}


// 읽은 공지사항 처리하는 함수
function markReadNotices(notices) {
    $(".btn_notice_view").each(function() {
        let noticeUid = $(this).attr("id");
        if (notices.includes(noticeUid)) {
            // 읽은 공지사항이면서 새로운 표시가 있는 경우에만 제거하도록 수정
            if ($(this).find('.new').length > 0) {
                $(this).find('.new').remove();
            }
        }
    });
}

// 공지 검색 함수
function searchNotices(keyword) {
    $('.notice_list li').each(function() {
        let noticeTitle = $(this).find('.btn_notice_view').text().toLowerCase(); 
        if (noticeTitle.indexOf(keyword) !== -1) {
            $(this).show();
        } else {
            $(this).hide(); 
        }
    });
}

// 이전에 보고 있던 탭을 다시 그리는 함수
// function redrawLastVisitedTab() {
//     let lastVisitedTabId = localStorage.getItem('lastVisitedTabId');
//     if (lastVisitedTabId) {
//         $("#tab_notice li a[data-category=" + lastVisitedTabId + "]").trigger("click");
//         getNotices(lastVisitedTabId);
//     }
// }

function getSelectedNotice(selectedNoticeUid) {
    let tempUrl = server_host + server_port + '/astroapi/notice/v1/notice/' + selectedNoticeUid;

    cordova.plugin.http.get(tempUrl, {}, {
        Authorization: 'Bearer ' + userData.astroToken
    }, function(response) {
        let jsonData = JSON.parse(response.data);
        let creatorName = jsonData.data.creator_name || "알 수 없음";
        let deptName = jsonData.data.dept_name || "알 수 없음";

        let noticeHtml = `
            <div class="head" style="-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none">
                <h4>[공지] ${jsonData.data.title}</h4>
                <p>작성자 : ${deptName} / ${creatorName}</p>
                <p>작성일 : ${formatDate(jsonData.data.create_time)}</p>
            </div>
            <div class="cont">
                ${jsonData.data.contents}
            </div>
            <div class="btn_box" style="-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none">
                ${(jsonData.data.creator === window.localStorage.getItem("verifyUser") && window.localStorage.getItem("noticeRegPermitted") === "true") ? '<a href="javascript:" class="notice_forward" data-uid="' + selectedNoticeUid + '">재전송</a>' : ''}
                <a href="#" class="notice_view_close">닫기</a>
            </div>`;
        $('.notice_pop_close').hide();
        $('#notice_container').html(noticeHtml);

        // 현재 활성화된 탭의 ID 저장
        let currentTabId = $("#tab_notice .tablink.active").attr("data-category");
        
        if (currentTabId) {
            localStorage.setItem('lastVisitedTabId', currentTabId);
        } else {
            console.error("현재 탭 ID를 찾을 수 없습니다.");
        }

        if (!readNoticeList.includes(jsonData.data.uid)) {
            readNoticeList.push(jsonData.data.uid);
            localStorage.setItem('readNoticeList', JSON.stringify(readNoticeList));
        }

    }, function(response) {
        console.error("공지사항 불러오기 실패:", response);
        popAlert("오류가 발생했습니다.<br/>잠시 후 다시 시도해 주세요");
    });
}

function editSelectedNotice(selectedNoticeUid){
    let tempUrl = server_host + server_port + '/astroapi/notice/v1/notice/' + selectedNoticeUid;

    cordova.plugin.http.get(tempUrl, {}, {
        Authorization: 'Bearer ' + userData.astroToken
    }, function (response) {
        let jsonData = JSON.parse(response.data);
        console.log('editSelectedNotice',"jsonData.data : " + JSON.stringify(jsonData.data));
        console.log('editSelectedNotice',selectedNoticeUid);

        $("#notice_edit_submit").text("수정");

        let deptCodes = jsonData.data.trgt_dept_codes.split(',');
        let deptNames = jsonData.data.trgt_dept_names.split(',');

        // 입력사항 초기화
        $("#notice_title").val(jsonData.data.title);
        $("#editor_main").summernote('code', jsonData.data.contents);
        $("input[name='category'][value='" + jsonData.data.category + "']").prop('checked', true);
        jsonData.data.start_time == null ? $("#selected_period").text("") : $("#selected_period").text(formatDate(jsonData.data.start_time) + " ~ " + formatDate(jsonData.data.end_time));
        $("input[name='target'][value='" + jsonData.data.trgt + "']").prop('checked', true).trigger('change');
        jsonData.data.start_time == null ? $("#unlimited").prop("checked", true).trigger("change") : $("#unlimited").prop("checked", false).trigger("change");
        target_dept_codes = jsonData.data.trgt == 'DEPT' ? deptCodes : [];
        target_dept_names = jsonData.data.trgt == 'DEPT' ? deptNames : [];

        if (jsonData.data.trgt == 'DEPT') {
            $("#selected_depts").empty(); // 선택한 부서 항목을 초기화합니다.
            deptNames.forEach(function(deptName) {
                let newListItem = $("<div class='swiper-slide'>" + deptName.trim() + " <a href='#' class='del'></a></div>");
                $(".picks.swiper-wrapper").append(newListItem);
            });
        } else {
            // DEPT가 아닌 경우에는 선택한 부서 항목을 숨깁니다.
            $("#selected_depts").empty(); // 선택한 부서 항목을 초기화합니다.
        }

        $(".notice_edit").stop().show();
        getNotices(categoryFilter);
        $(".notice_view").stop().hide();
        
    }, function (response) {
        console.log('editSelectedNotice',"공지사항 불러오기 실패 response status:" + JSON.stringify(response));
        console.log('editSelectedNotice',response.error);
        popAlert("오류가 발생했습니다.<br/>잠시 후 다시 시도해 주세요");
    });
};

// 공지사항 등록
function addNotice() {

    let dataSerializer = cordova.plugin.http.getDataSerializer();

    cordova.plugin.http.setDataSerializer('json');

    // 필요한 데이터를 HTML에서 가져오기
    let title = document.getElementById("notice_title").value;
    let contents = $("#editor_main").val();
    let startDate = $("#notice_start_date").val();
    let startTime = $("#notice_start_time").val();
    let endDate = $("#notice_end_date").val();
    let endTime = $("#notice_end_time").val();
    let category = $("input[name='category']:checked").val();
    let target = $("input[name='target']:checked").val();

    if(!$("#unlimited").is(":checked")){

        //공지사항 기본 유지일수 설정
        let def_remains = 0;

        try {
            def_remains = parseInt(settingData.notice_def_remains);
        } catch (error) {
            def_remains = 0;
        }
        
        if(startDate == '' && startTime == '' && endDate == '' && endTime == ''){
            let today = new Date(), sday = new Date(), eday = new Date(today.setDate(today.getDate() + def_remains)),y,M,d;

            y = sday.getFullYear().toString();
            M = (sday.getMonth()+1).toString();
            if(M.length == 1){ M = '0'+M; }
            d = sday.getDate().toString();
            if(d.length == 1){ d = '0'+d; }
            
            startDate = y+'.'+M+'.'+d;
            startTime = '00:00';

            y = eday.getFullYear().toString();
            M = (eday.getMonth()+1).toString();
            if(M.length == 1){ M = '0'+M; }
            d = eday.getDate().toString();
            if(d.length == 1){ d = '0'+d; }

            endDate = y+'.'+M+'.'+d;
            endTime = '23:59'

        }else if((startDate == '' && startTime != '') || (endDate == '' && endTime != '')){
            return popAlert('공지 기간을 정확히\n입력해주세요.');
        }else{
            if(startDate != '' && startTime == ''){
                startTime = '00:00';
            }

            if(endDate != '' && endTime == ''){
                endTime = '23:59';
            }
        }
    }

     // 시작일과 종료일이 유효한 값인지 확인하고 ISO 형식의 문자열로 변환
     let formattedStartTime = startDate && startTime ? formatDateTime(startDate, startTime) : null;
     let formattedEndTime = endDate && endTime ? formatDateTime(endDate, endTime) : null;

    // 데이터 객체 구성
    let data = {
        corp_code: serverData.corp_code,
        category: category,
        title: title,
        contents: contents,
        start_time: formattedStartTime,
        end_time: formattedEndTime,
        temp: 0,
        alarm_time: "",
        trgt: target,
        trgt_dept_codes: $("input[name='target']:checked").val() == 'DEPT' ? target_dept_codes.join(',') : "",
        trgt_dept_names: $("input[name='target']:checked").val() == 'DEPT' ? target_dept_names.join(',') : "",
    };

    if((title == "") || (contents == "")){
        return popAlert("입력사항을\n정확히 입력해주세요.");
    };

    if ((((startDate == "") || (startTime == "") || (endDate == "") || (endTime == "")) || ((startDate == undefined) || (startTime == undefined) || (endDate == undefined) || (endTime == undefined))) && ($("#unlimited").is(":checked") == false)){
        return popAlert("기간을\n정확히 입력해주세요.");
    };
    
    if (selectedNoticeUid == "") {
        let tempUrl = server_host + server_port + '/astroapi/notice/v1/notice';

        cordova.plugin.http.post(tempUrl, data, {
            Authorization: 'Bearer ' + userData.astroToken
        }, function(response) {
            let jsonData = JSON.parse(response.data);

            // 성공 시 작업
            getNotices(categoryFilter);
            $("#span_new_notice").addClass("new");
            $(".notice_edit").stop().hide();
            popConfirm("등록되었습니다.\n알림을 발송하시겠습니까?", function(){
                let storedNoticeId = jsonData.data.uid;
                sendNoticeAlert(storedNoticeId);
            });
        }, function(response) {
            console.log('addNotice',"등록 실패 : " + response);
            popAlert(response.error);
        });
    } else {
        let tempUrl = server_host + server_port + '/astroapi/notice/v1/notice/' + selectedNoticeUid;

        console.log('addNotice',"파라미터 잘 들어가는지 확인용 : " + JSON.stringify(data));
        cordova.plugin.http.put(tempUrl, data, {
            Authorization: 'Bearer ' + userData.astroToken
        }, function(response) {
            console.log('addNotice',"post 되긴하고 있는거임??" + response.data);
            // 성공 시 작업
            getNotices(categoryFilter);
            $(".notice_edit").stop().hide();
            popAlert("수정되었습니다.");
            target_dept_codes = [];
            target_dept_names = [];
        }, function(response) {
            console.log('addNotice',"수정 실패 : " + JSON.stringify(response.data));
            popAlert("오류가 발생했습니다.<br/>잠시 후 다시 시도해 주세요");
        });
    }
    cordova.plugin.http.setDataSerializer(dataSerializer);
};

function deleteNotice(selectedNoticeUid){
    let dataSerializer = cordova.plugin.http.getDataSerializer();

    cordova.plugin.http.setDataSerializer('utf8');

    let tempUrl = server_host + server_port + '/astroapi/notice/v1/notice/' + selectedNoticeUid;

    cordova.plugin.http.delete(tempUrl, {}, {
        Authorization: 'Bearer ' + userData.astroToken
    }, function (response) {

        popAlert("삭제되었습니다.");

        getNotices(categoryFilter);

    }, function (response) {
        console.log('deleteNotice',"공지사항 삭제 실패 response status:" + JSON.stringify(response));
        console.log('deleteNotice',response.error);
        popAlert("오류가 발생했습니다.<br/>잠시 후 다시 시도해 주세요");
    });
    cordova.plugin.http.setDataSerializer(dataSerializer);
};

function readNotice(selectedNoticeUid) {
    let dataSerializer = cordova.plugin.http.getDataSerializer();

    cordova.plugin.http.setDataSerializer('json');

    let tempUrl = server_host + server_port + '/astroapi/notice/v1/notice/read';

    let data = {
        notice_uid: selectedNoticeUid
    };

    cordova.plugin.http.put(tempUrl, data, {
        Authorization: 'Bearer ' + userData.astroToken
    }, function(response) {
        let jsonData = JSON.parse(response.data);
        console.log('readNotice',"jsonData.data : " + JSON.stringify(jsonData.data));
        popAlert("읽음 처리 되었습니다.");

    }, function(response) {
        console.log('readNotice',"공지사항 불러오기 실패 response status:" + JSON.stringify(response));
        console.log('readNotice',response.error);
        popAlert("오류가 발생했습니다.<br/>잠시 후 다시 시도해 주세요");
    });

    cordova.plugin.http.setDataSerializer(dataSerializer);
}

// 공지사항 알림 발송
function sendNoticeAlert(storedNoticeId){
    let dataSerializer = cordova.plugin.http.getDataSerializer();

    cordova.plugin.http.setDataSerializer('json');

    let tempUrl = server_host + server_port + '/astroapi/mdial/v1/notice/alarm/send';

    console.log('sendNoticeAlert',"sendNotice : " + storedNoticeId);
    
    let data = {
        notice_id : storedNoticeId
    }

    console.log('sendNoticeAlert',data);

    cordova.plugin.http.post(tempUrl, data, {
        Authorization: 'Bearer ' + userData.astroToken
    }, function (response) {
        let jsonData = JSON.parse(response.data);
        console.log('sendNoticeAlert',"jsonData.data : " + JSON.stringify(jsonData));
        popAlert("발송되었습니다.")
    }, function (response) {
        console.log('sendNoticeAlert',"공지사항 발송 실패 response status:" + JSON.stringify(response));
        console.log('sendNoticeAlert',response.error);
        popAlert("오류가 발생했습니다.<br/>잠시 후 다시 시도해 주세요");
    });

    cordova.plugin.http.setDataSerializer(dataSerializer);
};


//////---------- FUNCTION DEFINE END


$(()=>{

    //공지 제외조직에 속한 사용자가 로그인시에는 공지사항 경조사만 볼 수있음
    try {
        // 공지 제외 조직에 속한 사용자가 로그인한 경우
        if ((settingData.noticeManageGroups.split(",")).includes(settingData.deptCode)) {
            $(".notice_pop").stop().show();
    
            // 경조사 탭을 선택하고, 경조사 카테고리 공지사항만 로드
            getNotices("E");  // 경조사 카테고리
    
            let noticeRegPermitted = window.localStorage.getItem("noticeRegPermitted");
            if (noticeRegPermitted === "false") {
                $(".btn_notice_edit").stop().hide();
                $("#alarmSelect").stop().hide();
            } else {
                $(".btn_notice_edit").stop().show();
                $("#alarmSelect").stop().show();
            }
    
            $(".notice_pop_close").stop().hide();
    
            // 탭 제어: 경조사 탭만 활성화
            $("#tab_notice li a[data-category='E']").click();  // 경조사 탭 클릭
            $("#tab_notice li a[data-category='all']").parent().hide();  // 전체 탭 숨기기
            $("#tab_notice li a[data-category='N']").parent().css("visibility", 'hidden');  // 일반 탭 비활성화
    
        }
    } catch (error) {
        console.error("공지사항 경조사 로드 중 오류 발생:", error);
    }

    // 페이지가 로드될 때 읽은 공지사항 표시
    markReadNotices(readNoticeList);

    // 탭 클릭 시 공지사항 카테고리 변경
    $('#tab_notice .tablink').on('click', function(e) {
        e.preventDefault();
        let selectedCategory = $(this).data('category');
        if (localStorage.getItem('lastVisitedTabId') === selectedCategory) return;

        $('#tab_notice .tablink').removeClass('active');
        $(this).addClass('active');
        localStorage.setItem('lastVisitedTabId', selectedCategory);
        getNotices(selectedCategory);
    });

    // 공지사항 알림 발송 버튼 클릭 이벤트 핸들러 추가
    $(".btn_confirm_pop").click(function(){
        let selectedNoticeUid = $(this).closest("li").find(".btn_notice_view").attr("id");
        $(".btn_submit.sendNotice").data("notice-id", selectedNoticeUid); // 발송 버튼에 선택된 공지사항 ID 저장
        $(".confirm_pop").show(); // 확인 팝업 열기
    });

    $(".btn_edit_notice").click(function(){
        let selectedNoticeUid = $(this).closest("li").find(".btn_notice_view").attr("id");
        editSelectedNotice(selectedNoticeUid);
    });

    // 공지사항 삭제 버튼 클릭 이벤트 핸들러 추가
    $(".btn_delete_notice").click(function(){
        let selectedNoticeUid = $(this).closest("li").find(".btn_notice_view").attr("id");

        popConfirm('삭제하시겠습니까?\n삭제한 데이터는 복구 할 수 없습니다.', function(){
            deleteNotice(selectedNoticeUid); // 선택된 공지사항 삭제 함수 호출
        })
    });

    // 모두읽음 버튼 클릭 이벤트
    $("#readAllNotice").on("click", function(e) {
        e.preventDefault();
        readAllNotices();
    });

    // 모두삭제 버튼 클릭 이벤트
    $("#deleteAllNotice").on("click", function(e) {
        e.preventDefault();
        popConfirm("공지 사항을\n모두 삭제하시겠습니까?", function() {
            deleteAllNotices();
        });
    });

    // 알람 셀렉트 박스 변경 이벤트 핸들러
    $("#alarmSelect").change(function() {
        let currentTabLink = $(".tabnav li a.active");
        let currentTabHref = currentTabLink.data("category");
        $('a[data-category="' + currentTabHref + '"]').trigger("click");
    });

    $('.tab_wrap .tabcontent > div').hide();

    $(".notice_pop .popup_close").click(function(e){
        e.preventDefault();
        //getNoticesUids();
        $(".notice_pop").stop().hide();
    });

    // 공지 발송 확인 팝업 - 확인 버튼 클릭 시
    $(".btn_submit.sendNotice").click(function(e){
        e.preventDefault();
        // let selectedNoticeUid = $(this).closest("li").find(".btn_notice_view").attr("id"); // 선택된 공지사항 ID 가져오기
        let storedNoticeId = $(".btn_submit.sendNotice").data("notice-id");
        sendNoticeAlert(storedNoticeId); // 공지사항 알림 발송 함수 호출
        $(".confirm_pop").stop().hide(); // 확인 팝업 닫기
    });

    // 공지 발송 확인 팝업 - 취소 버튼 클릭 시
    $(".confirm_pop_close").click(function (e) {
        e.preventDefault();
        $(".confirm_pop").stop().hide(); // 확인 팝업 닫기
    });

    // 이벤트 위임을 사용하여 .btn_notice_view 요소 클릭 이벤트 처리
    $('ul.notice_list').on("click", "li", function(e){
        e.preventDefault();
        let selectedNoticeUid = $(this).find('.btn_notice_view').attr("id");
        getSelectedNotice(selectedNoticeUid);
        $(".notice_view").stop().show();
    });
    // 버튼 클릭 시 이벤트 전파 중단
    $('ul.notice_list').on("click", ".func button", function(e){
        e.preventDefault();
        e.stopPropagation();
    });


    // 전달 버튼으로 알림 발송
    $('.notice_pop').on("click", ".notice_forward", function(e){
        e.preventDefault();
        // alert(selectedNoticeUid);
        sendNoticeAlert($(this).data('uid'));
    });

    $(".notice_pop").on("click", ".notice_view_close", function(e) {
        e.preventDefault();
        $('.notice_pop_close').show();
    
        let lastVisitedTabId = localStorage.getItem('lastVisitedTabId');
    
        if (lastVisitedTabId) {
            getNotices(lastVisitedTabId, function() {
                selectedNoticeUid = "";
                $(".notice_view").stop().hide().empty();
    
                // 새 공지사항 알림 업데이트
                updateNewNoticeIndicator();
            });
        } else {
            selectedNoticeUid = "";
            $(".notice_view").stop().hide().empty();
        }
    });

    //공지등록 
    $(".btn_notice_edit").click(function(e){
        e.preventDefault();
        
        // 입력사항 초기화
        selectedNoticeUid = "";
        $("#notice_edit_submit").text("등록");
        $("#notice_title").val("");
        $("#editor_main").summernote('reset');
        $("input[name='category'][value='E']").prop('checked', true).trigger("change");
        $("#notice_start_date").val("");
        $("#notice_start_time").val("");
        $("#notice_end_date").val("");
        $("#notice_end_time").val("");
        $("#selected_period").text("");
        $("input[name='target'][value='ALL']").prop('checked', true).trigger("change");
        $("#unlimited").prop("checked", true).trigger("change")
        target_dept_codes = [];
        target_dept_names = [];
        $("#selected_depts").empty();

        $(".notice_edit").stop().show();
        $(".notice_view").stop().hide();
    });

    //공지등록 취소
    $(".notice_edit_close").click(function(e){
        e.preventDefault();
        $(".notice_edit").stop().hide();
        selectedNoticeUid = "";
    });

    //부서검색 팝업
    $(".btn_organ_pop").click(function (e) {
        e.preventDefault();
        $(".organ_pop").stop().show();
    });
    $(".organ_pop_close").click(function (e) {
        e.preventDefault();
        $(".organ_pop").stop().hide();
    });

    // 부서 선택 클릭 시 
    $(".btn_submit.choose_dept").click(function(e){
        e.preventDefault();
        if (window.localStorage.getArray("selected_dept_code") !== undefined) { 
            target_dept_codes.push(window.localStorage.getArray("selected_dept_code"));
            console.log('.btn_submit.choose_dept onclick',"target_dept_codes : " + target_dept_codes);
        }
        if (window.localStorage.getArray("selected_dept_name") !== undefined) { 
            target_dept_names.push(window.localStorage.getArray("selected_dept_name"));
            console.log('.btn_submit.choose_dept onclick',"target_dept_names : " + target_dept_names);

            let newListItem = $("<div class='swiper-slide'>" + target_dept_names + " <a href='#' class='del'></a></div>");
            $(".picks.swiper-wrapper").append(newListItem);
        }
        $(".organ_pop").stop().hide();
    });

    // 선택한 부서 취소
    $("#selected_depts").on("click", "a.del", function(e) {
        e.preventDefault();

        let deptItem = $(this).parent();
        let deptName = deptItem.text().trim();

        let index = target_dept_names.indexOf(deptName);
        if (index !== -1) {
            target_dept_names.splice(index, 1);
            target_dept_codes.splice(index, 1);
        }

        deptItem.remove();
    });

    // 공지 기간 설정 팝업 열기
    $(".btn_term_pop").click(function(e){
        e.preventDefault();
        $(".term_pop").stop().show();
    });

    $(".btn_close.term_pop_close").click(function(e){
        e.preventDefault();
        $(".term_pop").stop().hide();
    });

    // 기간 설정 팝업에서 확인 버튼 클릭 시
    $(".btn_submit.setTime").click(function (e) {
        e.preventDefault();

        let selectedTime; // 변수 선언

        if ($("#unlimited").prop("checked")) {
            selectedTime = null; // 체크박스가 체크되었을 때 null 할당
            $("#selected_period").text("");
        } else {
            // 시작일과 종료일을 가져와서 기간에 넣기
            let startDate = $("#notice_start_date").val();
            let startTime = $("#notice_start_time").val();
            let endDate = $("#notice_end_date").val();
            let endTime = $("#notice_end_time").val();

            // 선택한 시간을 기간에 삽입
            selectedTime = startDate + " " + startTime + " ~ " + endDate + " " + endTime;
        }

        console.log('btn_submit.setTime on click',selectedTime);

        // 선택한 시간을 #selected_period 레이블에 표시
        selectedTime == null || selectedTime == "  ~  " ? "" : $("#selected_period").text(selectedTime);

        // 팝업 닫기
        $(".term_pop").stop().hide();
    });

    // 공지사항 등록 버튼 클릭 이벤트
    $("#notice_edit_submit").on("click", function(e) {
        e.preventDefault();
        addNotice();
    });

    $('.notice_pop').on("click", ".pd_btn", function() {
        // 클릭된 pd_btn의 부모 요소(li)에서 id 값을 가져옴
        let selectedNoticeUid = $(this).closest("li").find(".btn_notice_view").attr("id");
        readNotice(selectedNoticeUid); // readNotice 함수 호출
    });

    //공지기간 제한없음
    $("#unlimited").on("change", function () {
        if ($(this).is(":checked")) {
            // Disable date/time inputs
            $("#notice_start_date").prop('disabled', true);
            $("#notice_start_time").prop('disabled', true);
            $("#notice_end_date").prop('disabled', true);
            $("#notice_end_time").prop('disabled', true);
        } else {
            // Enable date/time inputs
            $("#notice_start_date").prop('disabled', false);
            $("#notice_start_time").prop('disabled', false);
            $("#notice_end_date").prop('disabled', false);
            $("#notice_end_time").prop('disabled', false);
        }
    });

    // 탭 클릭 시 해당 카테고리의 항목만 표시하는 함수
    // $(".tablink").click(function() {
    //     let category = $(this).data("category");

    //     if (category === currentCategory) return;
    //     getNotices(category);

    //     $(".tablink").removeClass("active");
    //     $(this).addClass("active");

    //     currentCategory = category;
    // });

    // 닫기 버튼 클릭 시 "전체" 탭 클릭 이벤트 발생
    $(".notice_view_close").click(function(event){
        event.preventDefault();  // 기본 동작(페이지 이동) 막기
        // getNotices(localStorage.getItem('lastVisitedTabId'));
        redrawLastVisitedTab();
    });

    // 공지 검색 기능 구현
    $('#notice_srch_keyword').on('keyup', function() {
        let searchKeyword = $(this).val().toLowerCase().trim(); // 검색어를 소문자로 변환하여 가져옵니다.
        searchNotices(searchKeyword); // 검색어를 이용하여 공지사항을 검색합니다.
    });

    //공지사항진입 아이콘 숨기기/보여주기
    if(settingData.notice_used == 'Y'){
        $('#loadNoticesBtn').show();
    } else {
        $('#loadNoticesBtn').hide();
    }
    getNoticesUids();
});